//
//  CRQCRendererAdapter.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 12/8/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRSceneItemBase.h"
#import "CRQCRenderer.h"

extern NSString* const CRQCRendererAdapterFileDataKey;
extern NSString* const CRQCRendererRendererKey;
extern NSString* const CRQCRendererRendererChangedNotification;

//////////////////////////////////////////////////////////////////////
// QCRenderer adapter for Undo handling & overall better fit to
// Scene/SceneItem architecture
//////////////////////////////////////////////////////////////////////
@interface CRQCRendererAdapter : CRSceneItemBase<CRUndoable>
{
	BOOL			rendererReady;
	BOOL			rendererCopyParams;
	CRQCRenderer*	renderer;
	NSData*			fileData;
	NSSize			targetSize;
	
	BOOL			silence;
}

@property (nonatomic, readonly)	CRQCRenderer*	renderer;
@property (nonatomic, copy)		NSData*			fileData;
@property (nonatomic, assign)	NSSize			targetSize;
@property (nonatomic, assign)	BOOL			silence;

- (void)setComposition:(QCComposition *)composition;
- (void)rebuildQC;

@end